#include "CameraCBuffer.hlsli"
#include "SamplerStates.hlsli"

struct PSInput {
	float4 PositionClipS : SV_Position;
	float2 TexCoords : TEXCOORD0;
};

Texture2D<unorm float> DepthStencilTex : register(t0);

#include "Common.hlsli"
#include "DepthOfField.hlsli"

float2 main(PSInput input) : SV_TARGET
{
	float2 output;
	
	// Sample the depth and convert to linear view space Z
	float depth = DepthStencilTex.SampleLevel(LinearSampler, input.TexCoords, 0);
	float linearDepth = ProjectionB / (depth - ProjectionA);
	output.r = linearDepth;

	// Find CoC radius in film space (meters)
	float cocRadius = CalculateCoCRadiusFilmS(linearDepth);
	output.g = cocRadius;

	return output;
}